package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionBlockBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class QuestionBlockBeanImpl extends ControlConstructBeanImpl implements
		QuestionBlockBean {

	final private ReferenceBeanImpl<QuestionConstructBean> qcRef;
	final private ReferenceSetImpl<StatementItemBean> pretextRefSet;
	final private ReferenceSetImpl<StatementItemBean> posttextRefSet;

	public QuestionBlockBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		qcRef = new ReferenceBeanImpl<QuestionConstructBean>(
				QuestionConstructBean.class, factory, this);
		pretextRefSet = new ReferenceSetImpl<StatementItemBean>(
				StatementItemBean.class, beanInitializer, factory, this);
		posttextRefSet = new ReferenceSetImpl<StatementItemBean>(
				StatementItemBean.class, beanInitializer, factory, this);
	}
	
	public void initSetQuestionConstructUrn(String urn){
		qcRef.setReferenceUrn(urn);
	}
	
	public void initSetPretextUrns(String[] urns){
		pretextRefSet.initReferenceUrns(urns);
	}
	
	public void initSetPosttextUrns(String[] urns){
		posttextRefSet.initReferenceUrns(urns);
	}

	@Override
	public ControlConstructBean[] getControlConstructs() {
		List<ControlConstructBean> ccList = new ArrayList<ControlConstructBean>();
		StatementItemBean[] pretextArr = pretextRefSet
				.toArray(new StatementItemBean[0]);
		for (StatementItemBean stmt : pretextArr) {
			ccList.add(stmt);
		}
		if (qcRef.isSet() == false) {
			QuestionConstructBean qc;
			try {
				qc = qcRef.getReferredObject();
				ccList.add(qc);
			} catch (ResolverException e) {
				throw new RuntimeException(e);
			}
		}
		StatementItemBean[] posttextArr = posttextRefSet
				.toArray(new StatementItemBean[0]);
		for (StatementItemBean stmt : posttextArr) {
			ccList.add(stmt);
		}
		return ccList.toArray(new ControlConstructBean[0]);
	}

	@Override
	public boolean isSetQuestionConstruct() {
		return this.qcRef.isSet();
	}

	@Override
	public void setQuestionConstruct(QuestionConstructBean qc)
		 {
		this.qcRef.setReferenceTo(qc);
	}

	@Override
	public QuestionConstructBean getQuestionConstruct() {
		try {
			return this.qcRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public String getQuestionConstructUrn() {
		return this.qcRef.getUrn();
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another)  {
		super.doChangeReference(current, another);

		if (current instanceof QuestionConstructBean
				&& another instanceof QuestionConstructBean) {
			if (current.getUrn().equals(this.qcRef.getUrn())) {
				QuestionConstructBean anotherQc = (QuestionConstructBean) another;
				this.qcRef.setReferenceTo(anotherQc);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		super.doRemoveReference(toRemove);

		if (toRemove instanceof QuestionConstructBean) {
			if (toRemove.getUrn().equals(this.qcRef.getUrn())) {
				this.qcRef.unset();
			}
		}
	}

	@Override
	public ReferenceSet<StatementItemBean> getPretextList() {
		return this.pretextRefSet;
	}

	@Override
	public ReferenceSet<StatementItemBean> getPosttextList() {
		return this.posttextRefSet;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Sequence;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return QuestionBlockBean.class;
	}

}
