package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.datacollection.DynamicTextBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DynamicTextValueBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.LanguageKeyedValueBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class DynamicTextValueBeanImpl extends LanguageKeyedValueBeanImpl<DynamicTextBean> implements
		DynamicTextValueBean {

	public DynamicTextValueBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(DynamicTextBean.class, beanFactory, changeListener);		
	}

	@Override
	protected DynamicTextBean createNewBean(String lang,
			Map<Enum<?>, Object> keyMap) {
		return new DynamicTextBeanImpl(lang, keyMap, this.getBeanFactory(), this);
	}
	
	
}
