package org.openmetadata.beans.ddi.lifecycle.datacollection;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiedStructuredStringValueBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface CollectionEventBean extends IdentifiableBean{
	
	public final static DdiClass ddiClass = DdiClass.CollectionEvent;
	
	ReferenceSet<OrganizationBean> getOrganizations();
	
	DdiBeanList<DataSourceBean> getDataSourceList();
	
	DateBean getDataCollectionDate();
	
	DdiBeanList<DataCollectionFrequencyBean> getDataCollectionFrequncyList();
	
	IdentifiedStructuredStringValueBean getModeOfCollection();
	
	IdentifiedStructuredStringValueBean getCollectionSituation();
	
	IdentifiedStructuredStringValueBean getActionToMinimizeLosses();
}
