package org.openmetadata.beans.ddi.lifecycle.adt;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.DdiBean;

public interface ReferenceSet<B extends IdentifiableBean> extends DdiBean,
		Iterable<B> {

	boolean contains(B bean);

	boolean contains(String urn);

	/**
	 * Create and insert a new element into the set.
	 * 
	 * @return the newly created element
	 */
	boolean add(B bean);

	/**
	 * Removes the occurrence of the specified element from this set.
	 * 
	 * @param bean
	 * @return Returns <code>true</code> if the element is successfully removed
	 *         from this list.
	 */
	boolean remove(B bean);

	/**
	 * Removes the occurrence of the element from this set.
	 * 
	 * @param bean
	 * @return Returns <code>true</code> if the element is successfully removed
	 *         from this list.
	 */
	boolean remove(String urn);

	B[] toArray(B[] arr);

	int size();

	/**
	 * Returns the URN strings of the elements existing in this set. 
	 * @return
	 */
	String[] getUrns();

	/**
	 * Removes all of the elements from this set. The set will be empty after
	 * this call returns.
	 */
	void clear();

	/**
	 * Relocates the object given as the first parameter in front of an existing
	 * object given as the second parameter.
	 * 
	 * @param move
	 * @param before
	 */
	void moveBefore(B move, B before);

	/**
	 * Relocates the object given as the first parameter after an existing
	 * object given as the second parameter.
	 * 
	 * @param move
	 * @param before
	 */
	void moveAfter(B move, B after);
}
