package org.openmetadata.beans.ddi.lifecycle;

import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public class DdiBeans {
	
	/**
	 * Returns a DdiClass object that represents the DDI element type for a given IdentifiableBean class
	 * @param beanClass
	 * @return the DdiClass object 
	 */
	public static final DdiClass getDdiClass(Class<? extends IdentifiableBean> beanClass){
		try {
			Object obj = beanClass.getField("ddiClass").get(null);
			if(obj instanceof DdiClass){
				return (DdiClass) obj;							
			}else{		
				if(obj == null){
					throw new RuntimeException("The field ddiClass is not set in the class " + beanClass.getName());
				}else{
					throw new RuntimeException("The field ddiClass is not the type of DdiClass in the class " + beanClass.getName());
				}
			}			
		} catch (SecurityException e) {
			throw new RuntimeException(e);
		} catch (NoSuchFieldException e) {			
			throw new RuntimeException(e);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
	
}
