package org.openmetadata.beans.ddi.lifecycle.utility;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.openmetadata.beans.ddi.lifecycle.types.XmlDateDataType;

public class XmlDateUtils {

	public static String getXmlDateString(Date date, XmlDateDataType dateType) {
		if (dateType.equals(XmlDateDataType.GYEAR)) {
			return new SimpleDateFormat("yyyy").format(date);
		} else if (dateType.equals(XmlDateDataType.GYEARMONTH)) {
			return new SimpleDateFormat("yyyy-MM").format(date);
		} else if (dateType.equals(XmlDateDataType.DATE)) {
			return new SimpleDateFormat("yyyy-MM-dd").format(date);
		} else if (dateType.equals(XmlDateDataType.DATETIME)) {
			return (new SimpleDateFormat("yyyy-MM-dd").format(date)) + "T"
					+ (new SimpleDateFormat("HH:mm:ss").format(date));
		} else {
			// by default, return yyyy format
			return new SimpleDateFormat("yyyy").format(date);
		}
	}
}
