package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.NameBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.notification.ChangeListener;

public class NameBeanImpl extends AbstractInternationalStringBeanImpl implements
		NameBean {

	private Boolean isPreferred;

	public NameBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory,
			ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	@Override
	public boolean isSetIsPreferred() {
		return isPreferred != null;
	}

	@Override
	public boolean getIsPreferred() {
		if (isPreferred != null) {
			return isPreferred;
		} else {
			return false;
		}
	}

	@Override
	public void setIsPreferred(boolean isPreferred) {
		if (CompareUtil.areDifferentValues(this.isPreferred, isPreferred)) {
			this.isPreferred = isPreferred;
			populate();
			this.ddiBeanChanged();
		}
	}

}
