package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTimeRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTypeCode;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class DateTimeRepresentationBeanImpl extends RepresentationBeanImpl
		implements DateTimeRepresentationBean {

	private DateTypeCode type;
	private String format;

	public DateTimeRepresentationBeanImpl(DateTypeCode type,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		format = "";
		this.type = type;
	}

	@Override
	public DateTypeCode getType() {
		if (this.type != null) {
			return this.type;
		} else {
			return DateTypeCode.DATE;
		}
	}

	@Override
	public void setType(DateTypeCode type) {
		if (this.type != type) {
			this.type = type;
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getFormat() {
		if (format != null) {
			return format;
		} else {
			return "";
		}
	}

	@Override
	public void setFormat(String format) {
		if (CompareUtil.areDifferentValues(this.format, format)) {
			this.format = format;
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetFormat() {
		this.format = null;
	}

	@Override
	public boolean isSetFormat() {
		return format != null && format.isEmpty() == false;
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(format);
	}
}
