package org.openmetadata.beans.ddi.lifecycle.reusable;

import org.openmetadata.beans.ddi.lifecycle.DdiBean;
import org.openmetadata.beans.ddi.lifecycle.adt.ResolvingSet;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface IdentifiableBean extends DdiBean,
		org.openmetadata.beans.IdentifiableBean {
	
	final static DdiClass ddiClass = null;
	
	AttributeSet getAttributeSet();
		
	DdiClass getDdiClass();

	String getId();

	@Override
	Class<? extends IdentifiableBean> getBeanType();

	boolean isSetUrn();

	String getUrn();

	boolean isSetObjectSource();

	String getObjectSource();

	void setObjectSource(String value);

	boolean isSetAction();

	ActionCode getAction();

	void setAction(ActionCode action);
	
	UserIDValueBean getUserIDValues();

	NameValueBean getName();

	LabelValueBean getLabel();

	StructuredStringValueBean getDescription();
	
	IdentifiableBean[] getReferrers();

	ResolvingSet<IdentifiableBean> getReferrerSet();

	/**
	 * Made the bean to remove the reference to the previously referred bean and
	 * point to another bean. To make the bean refer to nothing, pass null to
	 * the bean to be newly referred to.
	 * 
	 * The client of this method expect the following to happen.
	 * 
	 * if current is not null and currently referred by this identifiable bean -
	 * if another is not null, this identifiable bean will refer to another - if
	 * another is null, this identifiable bean will have empty reference else do
	 * nothing
	 * 
	 * @param current
	 *            currently referred bean that is to be dereferenced
	 * @param another
	 *            Bean to be referred. It can be null.
	 * @throws ReferenceException
	 */
	void changeReference(IdentifiableBean current,
			IdentifiableBean another) ;

	void removeReference(IdentifiableBean toRemove);

	void copyNameLabelDescription(IdentifiableBean from);

}
