package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class CategoryStatisticsBeanImpl extends UnsettableDdiBeanImpl implements
		CategoryStatisticsBean {

	private String categoryValue;
	private DdiBeanListImpl<CategoryStatisticBean> categoryStatisticList;

	public CategoryStatisticsBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		categoryValue = "";
		categoryStatisticList = new DdiBeanListImpl<CategoryStatisticBean>(
				CategoryStatisticBean.class, beanInitializer, factory, this) {
			@Override
			protected CategoryStatisticBean createNew() {
				return new CategoryStatisticBeanImpl(categoryValue, getBeanFactory(), this);
			}
		};
	}

	@Override
	public String getCategoryValue() {
		return (categoryValue != null) ? categoryValue : "";
	}

	@Override
	public void setCategoryValue(String value) {
		if (CompareUtil.areDifferentValues(categoryValue, value)) {
			categoryValue = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public DdiBeanListImpl<CategoryStatisticBean> getCategoryStaticList() {
		return categoryStatisticList;
	}
	
	@Override
	protected boolean internalIsSet() {
		return categoryStatisticList.size()>0 || !StringUtils.isEmpty(categoryValue);
	}
}
