package org.openmetadata.beans.ddi.lifecycle.physicalinstance;

import org.openmetadata.datacube.DimensionKey;

public enum CategoryStatisticTypeDimension implements DimensionKey<CategoryStatisticTypeDimension> {
	
	FREQUENCY, 
	PERCENT,
	CROSS_TABULATION,
	VALID_CASES,
	INVALID_CASES,
	MINIMUM,
	MAXIMUM,
	STANDARD_DEVIATION,
	CUMULATIVE_PERCENT,
	USE_OTHER;
	
	private CategoryStatisticTypeDimension() {
		
	}

	@Override
	public CategoryStatisticTypeDimension getValue() {
		return this;
	}

	@Override
	public String getType() {
		return CategoryStatisticTypeDimension.class.getName()+"."+toString();
	}

	@Override
	public Class<? extends DimensionKey<?>> getTypeClass() {
		return CategoryStatisticTypeDimension.class;
	}

	@Override
	public String getTextValue() {
		return toString();
	}
}
