package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CodingBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableCodeRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTimeRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTypeCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.ExternalCategoryRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericTypeCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.TextRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DateTimeRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ExternalCategoryRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.NumericRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.TextRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.types.VariableRepresentationType;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;

public class VariableRepresentationBeanImpl extends UnsettableDdiBeanImpl
		implements VariableRepresentationBean {

	private final VariableBean variable;
	private String measurementUnit;
	private String role;
	private ReferenceBeanImpl<CodingBean> codingInstructionRef;

	private VariableRepresentationType varRepType = VariableRepresentationType.None;

	private VariableCodeRepresentationBeanImpl codeRep;
	private NumericRepresentationBean numericRep;
	private DateTimeRepresentationBean dateTimeRep;
	private TextRepresentationBean textRep;
	private ExternalCategoryRepresentationBean extCategoryRep;

	public VariableRepresentationBeanImpl(VariableBean variable,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		this.variable = variable;
		
		codingInstructionRef = new ReferenceBeanImpl<CodingBean>(CodingBean.class, factory, this);
	}
	
	public void initSetCodingInstructionUrn(String codingUrn){
		codingInstructionRef.setReferenceUrn(codingUrn);
	}
	
	@Override
	public boolean isSetCodingInstruction() {
		return codingInstructionRef.isSetUrn();
	}
	
	@Override
	public String getCodingInstructionUrn() {
		return codingInstructionRef.getUrn();
	}
	
	@Override
	public CodingBean getCodingInstruction() {
		try {
			return codingInstructionRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}
		
	@Override
	public void setCodingInstruction(CodingBean coding) {
		codingInstructionRef.setReferenceTo(coding);
	}
	
	@Override
	public void unsetCodingInstruction() {
		codingInstructionRef.unset();
	}

	@Override
	public VariableRepresentationType getRepresentationType() {
		return this.varRepType;
	}

	@Override
	public String getMeasurementUnit() {
		return StringUtils.defaultString(measurementUnit);
	}

	@Override
	public void setMeasurementUnit(String measurementUnit) {
		this.measurementUnit = measurementUnit;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetMeasurementUnit() {
		return measurementUnit != null;
	}

	@Override
	public String getRole() {
		return StringUtils.defaultString(role);
	}

	@Override
	public void setRole(String role) {
		this.role = role;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetRole() {
		return role != null;
	}
	
	@Override
	protected boolean internalIsSet() {
		return varRepType != VariableRepresentationType.None;
	}

	@Override
	public boolean isCodeRepresentation() {
		return this.codeRep != null
				&& (this.varRepType == VariableRepresentationType.Code);
	}

	@Override
	public VariableCodeRepresentationBean getCodeRepresentation() {
		return this.codeRep;
	}

	public VariableCodeRepresentationBean initChangeToCodeRepresentation(
			String codeSchemeUrn) throws URNFormatException {
		this.varRepType = VariableRepresentationType.Code;
		if (this.codeRep == null) {
			this.codeRep = new VariableCodeRepresentationBeanImpl(variable,
					this.getBeanFactory(), this);
			this.ddiBeanChanged();
			this.codeRep.initSetCodeSchemeUrn(codeSchemeUrn);
		}
		return this.codeRep;
	}

	@Override
	public VariableCodeRepresentationBean changeToCodeRepresentation(
			CodeSchemeBean codeScheme)  {
		this.varRepType = VariableRepresentationType.Code;
		if (this.codeRep == null) {
			this.codeRep = new VariableCodeRepresentationBeanImpl(variable,
					this.getBeanFactory(), this);
			this.ddiBeanChanged();			
		} 
		this.codeRep.setCodeScheme(codeScheme);
		return this.codeRep;
	}

	@Override
	public boolean isNumericRepresentation() {
		return this.numericRep != null
				&& (this.varRepType == VariableRepresentationType.Numeric);
	}

	@Override
	public NumericRepresentationBean getNumericRepresentation() {
		return this.numericRep;
	}

	@Override
	public NumericRepresentationBean changeToNumericRepresentation(
			NumericTypeCode numericTypeCode) {
		this.unsetCodeRepresentationIfSet();
		this.varRepType = VariableRepresentationType.Numeric;
		if (this.numericRep == null) {
			this.numericRep = new NumericRepresentationBeanImpl(
					numericTypeCode, this.getBeanFactory(), this);
			this.ddiBeanChanged();
		}
		this.numericRep.setType(numericTypeCode);
		return numericRep;
	}

	@Override
	public boolean isTextRepresentation() {
		return textRep != null
				&& (this.varRepType == VariableRepresentationType.Text);
	}

	@Override
	public TextRepresentationBean getTextRepresentation() {
		return textRep;
	}

	@Override
	public TextRepresentationBean changeToTextRepresentation() {
		this.unsetCodeRepresentationIfSet();
		this.varRepType = VariableRepresentationType.Text;
		if (this.textRep == null) {
			this.textRep = new TextRepresentationBeanImpl(
					this.getBeanFactory(), this);
			this.ddiBeanChanged();
		}
		return textRep;
	}

	@Override
	public boolean isExternalCategoryRepresentation() {
		return this.extCategoryRep != null
				&& (this.varRepType == VariableRepresentationType.ExternalCategory);
	}

	@Override
	public ExternalCategoryRepresentationBean getExternalCategoryRepresentation() {
		return this.extCategoryRep;
	}

	@Override
	public ExternalCategoryRepresentationBean changeToExternalCategoryRepresentation() {
		this.unsetCodeRepresentationIfSet();
		this.varRepType = VariableRepresentationType.ExternalCategory;
		if (this.extCategoryRep == null) {
			this.extCategoryRep = new ExternalCategoryRepresentationBeanImpl(
					this.getBeanFactory(), this);
			this.ddiBeanChanged();
		}
		return extCategoryRep;
	}

	@Override
	public boolean isDateTimeRepresentation() {
		return this.dateTimeRep != null
				&& (this.varRepType == VariableRepresentationType.DateTime);
	}

	@Override
	public DateTimeRepresentationBean getDateTimeRepresentation() {
		return this.dateTimeRep;
	}

	@Override
	public DateTimeRepresentationBean changeToDateTimeRepresentation(
			DateTypeCode dateTypeCode) {
		this.unsetCodeRepresentationIfSet();
		this.varRepType = VariableRepresentationType.DateTime;
		if (this.dateTimeRep == null) {
			this.dateTimeRep = new DateTimeRepresentationBeanImpl(dateTypeCode,
					this.getBeanFactory(), this);
			this.ddiBeanChanged();			
		}
		this.dateTimeRep.setType(dateTypeCode);
		return this.dateTimeRep;
	}
	
	private void unsetCodeRepresentationIfSet() {
		if(this.codeRep!=null) {
			this.codeRep.unset();
		}
	}
	
	@Override
	protected void doInternalUnset() {
		super.doInternalUnset();
		unsetCodeRepresentationIfSet();
	}
}
