package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategorySchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class CategoryBeanImpl extends
		AbstractSchemeItemBean<CategorySchemeBean> implements CategoryBean {

	private Boolean isMissing = null;

	public CategoryBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
	}

	@Override
	public boolean isSetMissing() {
		return isMissing != null;
	}

	@Override
	public void setMissing(boolean value) {
		this.isMissing = value;
		this.change();
	}
	
	@Override
	public void unsetMissing() {
		this.isMissing = null;
		this.change();
	}

	@Override
	public boolean getMissing() {
		if (isMissing != null) {
			return isMissing;
		} else {
			return false;
		}
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {

	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {

	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Category;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CategoryBean.class;
	}
}
