package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.HashMap;
import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.adt.KeyedBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class KeyedBeanImpl extends UnsettableDdiBeanImpl implements KeyedBean{
	
	private final Map<Enum<?>, Object> keyMap;

	public KeyedBeanImpl(Map<Enum<?>, Object> keyMap, DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		this.keyMap = keyMap;
	}

	@Override
	public Map<Enum<?>, Object> getKeyMap() {
		Map<Enum<?>, Object> unbackedMap = new HashMap<Enum<?>, Object>();
		unbackedMap.putAll(keyMap);
		return unbackedMap;
	}

	@Override
	protected boolean internalIsSet() {
		return !keyMap.isEmpty();
	}
}
