package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public class InlineSchemeItemListImpl<B extends IdentifiableBean> extends SchemeItemListImpl<B> {
	private static Logger logger = Logger.getLogger(InlineSchemeItemListImpl.class);
	
	private Set<B> beanSet = new LinkedHashSet<B>();

	public InlineSchemeItemListImpl(String maintainableUrn, Class<B> beanClass,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory, ChangeListener listener) {
		super(maintainableUrn, beanClass, beanInitializer, beanFactory, listener);
	}
	
	@Override
	public void initAddIdentifiableUrn(String urn) {
		B bean;
		try {
			bean = this.getResolver().resolve(this.getBeanClass(), urn);
			beanSet.add(bean);
		} catch (ResolverException e) {
			logger.error(e.getMessage(), e);
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public void initSetIdentifiableUrns(String[] urns) {		
		Set<String> urnSet = new HashSet<String>();
		urnSet.addAll(Arrays.asList(urns));
		try {
			Set<? extends B> beans = this.getResolver().resolve(this.getBeanClass(), urnSet);
			for(B bean : beans){
				beanSet.add(bean);
			}
		} catch (ResolverException e) {
			logger.error(e.getMessage(), e);
			throw new RuntimeException(e);
		}		
	}
	
	@Override
	public void initAddIdentifiableBean(B bean) {
		beanSet.add(bean);
	};
	
	@Override
	public void initSetIdentifiableBeans(B[] beans) {
		for(B bean : beans){
			beanSet.add(bean);
		}
	};
	
	@Override
	protected boolean add(B bean) {
		if(beanSet.contains(bean)) {
			return false;
		}else{
			return beanSet.add(bean);
		}
	}

	@Override
	public Iterator<B> iterator() {
		return beanSet.iterator();
	}
	
	@Override
	public boolean contains(B bean) {
		return beanSet.contains(bean);
	}

	@Override
	public boolean remove(B bean) {
		boolean result = beanSet.remove(bean);		
		if(result){
			for (IdentifiableBean referrer : bean.getReferrers()) {
				referrer.removeReference(bean);
			}
		}		
		this.notifyChange(new IdentifiableChangeEventImpl(Type.DELETE, bean));
		return result;
	}

	@Override
	public void moveBefore(B move, B before) {
		Set<B> tmpSet = new LinkedHashSet<B>();
		tmpSet.addAll(beanSet);
		
		beanSet.clear();
		for(B bean : tmpSet){
			if(bean.equals(move) == false){
				if(bean.equals(before)){
					beanSet.add(move);
				}
				beanSet.add(bean);
			}
		}
		this.ddiBeanChanged();
	}

	@Override
	public void moveAfter(B move, B after) {
		Set<B> tmpSet = new LinkedHashSet<B>();
		tmpSet.addAll(beanSet);
		
		beanSet.clear();
		for(B bean : tmpSet){
			if(bean.equals(move) == false){				
				beanSet.add(bean);
				if(bean.equals(after)){
					beanSet.add(move);
				}
			}
		}
		this.ddiBeanChanged();
	}

	@Override
	public int size() {
		return beanSet.size();
	}

	@Override
	public void sort(Comparator<B> comparator) {
			
		B[] tmpArr = this.toArray();		
		List<B> tmpList = Arrays.asList(tmpArr);
		Collections.sort(tmpList, comparator);
		// clear all the urns in the set
		beanSet.clear();
		for(B bean : tmpList){
			beanSet.add(bean);
		}
		this.ddiBeanChanged();
	}

	@Override
	public B[] toArray() {		
		@SuppressWarnings("unchecked")
		B[] typeArr = (B[]) Array.newInstance(this.getBeanClass(),0);		
		return beanSet.toArray(typeArr);
	}

	@Override
	public String[] getUrns() {
		List<String> urns = new ArrayList<String>();
		for(B bean : beanSet){
			urns.add(bean.getUrn());
		}
		return urns.toArray(new String[0]);
	}

	

}