package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DirectedEdge;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.impl.DdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DirectedEdgeImpl<B extends IdentifiableBean> extends DdiBeanImpl
		implements DirectedEdge<B> {
	
	private String parentObjectUrn;
	private ReferenceBeanImpl<B> sourceRef;
	private ReferenceBeanImpl<B> targetRef;

	public DirectedEdgeImpl(String referringUrn, Class<B> beanClass,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory, ChangeListener changeListener) {
		super(beanInitializer, beanFactory, changeListener);
		parentObjectUrn = referringUrn;
		sourceRef = new ReferenceBeanImpl<B>(beanClass, beanFactory, changeListener);
		targetRef = new ReferenceBeanImpl<B>(beanClass, beanFactory, changeListener);
	}
	
	public void initSetSource(String urn){
		sourceRef.setReferenceUrn(urn);
	}
	
	public void initSetTarget(String urn){
		targetRef.setReferenceUrn(urn);
	}
	
	@Override
	public String getSourceUrn() {
		return sourceRef.getUrn();
	}
	
	@Override
	public String getTargetUrn() {
		return targetRef.getUrn();
	}

	@Override
	public B getSource() {
		if(sourceRef.isSet()){
			try {
				return sourceRef.getReferredObject();
			} catch (ResolverException e) {
				throw new RuntimeException(e);
			}
		}else{
			return null;
		}
	}

	@Override
	public B getTarget() {
		if(targetRef.isSet()){
			try {
				return targetRef.getReferredObject();
			} catch (ResolverException e) {
				throw new RuntimeException(e);
			}
		}else{
			return null;
		}
	}
}