/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceAddedEvent;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceRemovedEvent;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceReplacedEvent;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.ReferenceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;

public class ReferenceBeanImpl<B extends IdentifiableBean>
extends UnsettableDdiBeanImpl
implements ReferenceBean<B> {
    private static final Logger logger = Logger.getLogger(ReferenceBeanImpl.class);
    private static final boolean DEFAULT_IS_EXTERNAL = false;
    private static final boolean DEFAULT_IS_REFERENCE = true;
    private static final boolean DEFAULT_LATE_BOUND = false;
    private Boolean isExternal;
    private Boolean isReference;
    private Boolean lateBound;
    private String objectLanguage;
    private String sourceContext;
    private ReferenceBean<IdentifiableBean> scheme;
    private Class<B> beanClass;
    private URN urn;

    public ReferenceBeanImpl(Class<B> beanClass, DdiBeanFactory factory, ChangeListener listener) {
        super(factory, listener);
        this.beanClass = beanClass;
    }

    public void setReferenceUrn(String newUrnStr) throws URNFormatException {
        String toRemoveUrn = this.urn != null ? this.urn.toString() : null;
        this.urn = URN.getURN((String)newUrnStr);
        this.notifyChange(new ReferenceReplacedEvent(newUrnStr, toRemoveUrn));
    }

    @Override
    public boolean isReferring(B bean) {
        return this.urn != null && bean != null ? this.urn.toString().equalsIgnoreCase(bean.getUrn()) : false;
    }

    @Override
    public boolean getIsExternal() {
        if (this.isSetIsExternal()) {
            return this.isExternal;
        }
        return false;
    }

    @Override
    public void setIsExternal(boolean isExternal) {
        if (CompareUtil.areDifferentValues(this.isExternal, isExternal)) {
            this.isExternal = isExternal;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetIsExternal() {
        return this.isExternal != null;
    }

    @Override
    public boolean getIsReference() {
        if (this.isSetIsReference()) {
            return this.isReference;
        }
        return true;
    }

    @Override
    public void setIsReference(boolean isReference) {
        if (CompareUtil.areDifferentValues(this.isReference, isReference)) {
            this.isReference = isReference;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetIsReference() {
        return this.isReference != null;
    }

    @Override
    public boolean getLateBound() {
        if (this.isSetLateBound()) {
            return this.lateBound;
        }
        return false;
    }

    @Override
    public void setLateBound(boolean boo) {
        if (CompareUtil.areDifferentValues(this.lateBound, boo)) {
            this.lateBound = boo;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetLateBound() {
        return this.lateBound != null;
    }

    @Override
    public String getObjectLanguage() {
        return StringUtils.defaultString((String)this.objectLanguage);
    }

    @Override
    public void setObjectLanguage(String value) {
        if (CompareUtil.areDifferentValues(this.objectLanguage, value)) {
            this.objectLanguage = value;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetObjectLanguage() {
        return this.objectLanguage != null;
    }

    @Override
    public String getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public void setSourceContext(String value) {
        if (CompareUtil.areDifferentValues(this.sourceContext, value)) {
            this.sourceContext = value;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetSourceContext() {
        return this.sourceContext != null;
    }

    @Override
    public boolean isSetScheme() {
        return this.scheme != null;
    }

    @Override
    @Deprecated
    public ReferenceBean<IdentifiableBean> getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isSetUrn() {
        return this.urn != null;
    }

    @Override
    public String getUrn() {
        return this.urn != null ? this.urn.toString() : "";
    }

    private void internalSetReferenceTo(B bean) throws URNFormatException {
        assert (bean != null);
        if (this.urn != null) {
            if (!this.urn.toString().equals(bean.getUrn())) {
                String toRemoveUrn = this.urn.toString();
                this.urn = URN.getURN((String)bean.getUrn());
                this.notifyChange(new ReferenceReplacedEvent(bean.getUrn(), toRemoveUrn));
                this.populate();
            }
        } else {
            this.urn = URN.getURN((String)bean.getUrn());
            this.notifyChange(new ReferenceAddedEvent(bean.getUrn()));
            this.populate();
        }
    }

    @Override
    public void setReferenceTo(B bean) {
        if (bean != null) {
            try {
                this.internalSetReferenceTo(bean);
            }
            catch (URNFormatException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            logger.error((Object)"The given bean is null.");
            throw new RuntimeException("Bean must not be null.");
        }
    }

    @Override
    public B getReferredObject() throws ResolverException {
        if (this.urn != null) {
            String urn = this.getUrn();
            IdentifiableBean idBean = (IdentifiableBean)this.getResolver().resolve(this.beanClass, urn);
            if (idBean != null) {
                return (B)idBean;
            }
        }
        throw new ResolverException(new String[0]);
    }

    @Override
    protected void doInternalUnset() {
        super.doInternalUnset();
        if (this.urn != null) {
            this.notifyChange(new ReferenceRemovedEvent(this.urn.toString()));
            this.urn = null;
        }
    }

    @Override
    public final boolean internalIsSet() {
        return this.urn != null;
    }
}

