/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionBlockBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ControlConstructBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class QuestionBlockBeanImpl
extends ControlConstructBeanImpl
implements QuestionBlockBean {
    private final ReferenceBeanImpl<QuestionConstructBean> qcRef;
    private final ReferenceSetImpl<StatementItemBean> pretextRefSet;
    private final ReferenceSetImpl<StatementItemBean> posttextRefSet;

    public QuestionBlockBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.qcRef = new ReferenceBeanImpl<QuestionConstructBean>(QuestionConstructBean.class, factory, (ChangeListener)this);
        this.pretextRefSet = new ReferenceSetImpl<StatementItemBean>(StatementItemBean.class, beanInitializer, factory, (ChangeListener)this);
        this.posttextRefSet = new ReferenceSetImpl<StatementItemBean>(StatementItemBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetQuestionConstructUrn(String urn) {
        this.qcRef.setReferenceUrn(urn);
    }

    public void initSetPretextUrns(String[] urns) {
        this.pretextRefSet.initReferenceUrns(urns);
    }

    public void initSetPosttextUrns(String[] urns) {
        this.posttextRefSet.initReferenceUrns(urns);
    }

    @Override
    public ControlConstructBean[] getControlConstructs() {
        StatementItemBean[] posttextArr;
        StatementItemBean[] pretextArr;
        ArrayList<ControlConstructBean> ccList = new ArrayList<ControlConstructBean>();
        StatementItemBean[] statementItemBeanArray = pretextArr = (StatementItemBean[])this.pretextRefSet.toArray(new StatementItemBean[0]);
        int n = pretextArr.length;
        int n2 = 0;
        while (n2 < n) {
            StatementItemBean stmt = statementItemBeanArray[n2];
            ccList.add(stmt);
            ++n2;
        }
        if (!this.qcRef.isSet()) {
            try {
                QuestionConstructBean qc = this.qcRef.getReferredObject();
                ccList.add(qc);
            }
            catch (ResolverException e) {
                e.printStackTrace();
            }
        }
        StatementItemBean[] statementItemBeanArray2 = posttextArr = (StatementItemBean[])this.posttextRefSet.toArray(new StatementItemBean[0]);
        int n3 = posttextArr.length;
        n = 0;
        while (n < n3) {
            StatementItemBean stmt = statementItemBeanArray2[n];
            ccList.add(stmt);
            ++n;
        }
        return ccList.toArray(new ControlConstructBean[0]);
    }

    @Override
    public boolean isSetQuestionConstruct() {
        return this.qcRef.isSet();
    }

    @Override
    public void setQuestionConstruct(QuestionConstructBean qc) {
        this.qcRef.setReferenceTo(qc);
    }

    @Override
    public QuestionConstructBean getQuestionConstruct() {
        try {
            return this.qcRef.getReferredObject();
        }
        catch (ResolverException e) {
            return null;
        }
    }

    @Override
    public String getQuestionConstructUrn() {
        return this.qcRef.getUrn();
    }

    @Override
    public void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
        super.doChangeReference(current, another);
        if (current instanceof QuestionConstructBean && another instanceof QuestionConstructBean && current.getUrn().equals(this.qcRef.getUrn())) {
            QuestionConstructBean anotherQc = (QuestionConstructBean)another;
            this.qcRef.setReferenceTo(anotherQc);
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        super.doRemoveReference(toRemove);
        if (toRemove instanceof QuestionConstructBean && toRemove.getUrn().equals(this.qcRef.getUrn())) {
            this.qcRef.unset();
        }
    }

    @Override
    public ReferenceSet<StatementItemBean> getPretextList() {
        return this.pretextRefSet;
    }

    @Override
    public ReferenceSet<StatementItemBean> getPosttextList() {
        return this.posttextRefSet;
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.Sequence;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return QuestionBlockBean.class;
    }
}

