/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public class InlineSchemeItemListImpl<B extends IdentifiableBean>
extends SchemeItemListImpl<B> {
    private static Logger logger = Logger.getLogger(InlineSchemeItemListImpl.class);
    private Set<B> beanSet = new LinkedHashSet<B>();

    public InlineSchemeItemListImpl(String maintainableUrn, Class<B> beanClass, MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory, ChangeListener listener) {
        super(maintainableUrn, beanClass, beanInitializer, beanFactory, listener);
    }

    @Override
    public void initAddIdentifiableUrn(String urn) {
        try {
            IdentifiableBean bean = (IdentifiableBean)this.getResolver().resolve(this.getBeanClass(), urn);
            this.beanSet.add(bean);
        }
        catch (ResolverException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initSetIdentifiableUrns(String[] urns) {
        HashSet<String> urnSet = new HashSet<String>();
        urnSet.addAll(Arrays.asList(urns));
        try {
            Set beans = this.getResolver().resolve(this.getBeanClass(), urnSet);
            for (IdentifiableBean bean : beans) {
                this.beanSet.add(bean);
            }
        }
        catch (ResolverException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initAddIdentifiableBean(B bean) {
        this.beanSet.add(bean);
    }

    @Override
    public void initSetIdentifiableBeans(B[] beans) {
        B[] BArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            B bean = BArray[n2];
            this.beanSet.add(bean);
            ++n2;
        }
    }

    @Override
    protected boolean add(B bean) {
        if (this.beanSet.contains(bean)) {
            return false;
        }
        return this.beanSet.add(bean);
    }

    @Override
    public Iterator<B> iterator() {
        return this.beanSet.iterator();
    }

    @Override
    public boolean contains(B bean) {
        return this.beanSet.contains(bean);
    }

    @Override
    public boolean remove(B bean) {
        boolean result = this.beanSet.remove(bean);
        if (result) {
            IdentifiableBean[] identifiableBeanArray = bean.getReferrers();
            int n = identifiableBeanArray.length;
            int n2 = 0;
            while (n2 < n) {
                IdentifiableBean referrer = identifiableBeanArray[n2];
                referrer.removeReference((IdentifiableBean)bean);
                ++n2;
            }
        }
        this.notifyChange((ChangeEvent)new IdentifiableChangeEventImpl(ChangeEvent.Type.DELETE, bean, new ChangeEvent[0]));
        return result;
    }

    @Override
    public void moveBefore(B move, B before) {
        LinkedHashSet<B> tmpSet = new LinkedHashSet<B>();
        tmpSet.addAll(this.beanSet);
        this.beanSet.clear();
        for (IdentifiableBean bean : tmpSet) {
            if (bean.equals(move)) continue;
            if (bean.equals(before)) {
                this.beanSet.add(move);
            }
            this.beanSet.add(bean);
        }
        this.ddiBeanChanged();
    }

    @Override
    public void moveAfter(B move, B after) {
        LinkedHashSet<B> tmpSet = new LinkedHashSet<B>();
        tmpSet.addAll(this.beanSet);
        this.beanSet.clear();
        for (IdentifiableBean bean : tmpSet) {
            if (bean.equals(move)) continue;
            this.beanSet.add(bean);
            if (!bean.equals(after)) continue;
            this.beanSet.add(move);
        }
        this.ddiBeanChanged();
    }

    @Override
    public int size() {
        return this.beanSet.size();
    }

    @Override
    public void sort(Comparator<B> comparator) {
        IdentifiableBean[] tmpArr = this.toArray();
        List<IdentifiableBean> tmpList = Arrays.asList(tmpArr);
        Collections.sort(tmpList, comparator);
        this.beanSet.clear();
        for (IdentifiableBean bean : tmpList) {
            this.beanSet.add(bean);
        }
        this.ddiBeanChanged();
    }

    @Override
    public B[] toArray() {
        IdentifiableBean[] typeArr = (IdentifiableBean[])Array.newInstance(this.getBeanClass(), 0);
        return this.beanSet.toArray(typeArr);
    }

    @Override
    public String[] getUrns() {
        ArrayList<String> urns = new ArrayList<String>();
        for (IdentifiableBean bean : this.beanSet) {
            urns.add(bean.getUrn());
        }
        return urns.toArray(new String[0]);
    }
}

