/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DirectedEdge;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.impl.DdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DirectedEdgeImpl<B extends IdentifiableBean>
extends DdiBeanImpl
implements DirectedEdge<B> {
    private String parentObjectUrn;
    private ReferenceBeanImpl<B> sourceRef;
    private ReferenceBeanImpl<B> targetRef;

    public DirectedEdgeImpl(String referringUrn, Class<B> beanClass, MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory, ChangeListener changeListener) {
        super(beanInitializer, beanFactory, changeListener);
        this.parentObjectUrn = referringUrn;
        this.sourceRef = new ReferenceBeanImpl<B>(beanClass, beanFactory, changeListener);
        this.targetRef = new ReferenceBeanImpl<B>(beanClass, beanFactory, changeListener);
    }

    public void initSetSource(String urn) {
        this.sourceRef.setReferenceUrn(urn);
    }

    public void initSetTarget(String urn) {
        this.targetRef.setReferenceUrn(urn);
    }

    @Override
    public String getSourceUrn() {
        return this.sourceRef.getUrn();
    }

    @Override
    public String getTargetUrn() {
        return this.targetRef.getUrn();
    }

    @Override
    public B getSource() {
        if (this.sourceRef.isSet()) {
            try {
                return this.sourceRef.getReferredObject();
            }
            catch (ResolverException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public B getTarget() {
        if (this.targetRef.isSet()) {
            try {
                return this.targetRef.getReferredObject();
            }
            catch (ResolverException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

