package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.NameValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SeriesStatementBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class SeriesStatementBeanImpl extends UnsettableDdiBeanImpl implements
		SeriesStatementBean {

	private NameValueBean name;
	private StructuredStringValueBean description;
	private List<String> abbrevation;
	private String seriesRepoLocation;

	public SeriesStatementBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		name = new NameValueBeanImpl(factory, this);
		description = new StructuredStringValueBeanImpl(factory, this);
		abbrevation = new ArrayList<String>();
	}

	@Override
	public StructuredStringValueBean getDescription() {
		return description;
	}

	@Override
	public List<String> getAbbrevations() {
		return abbrevation;
	}

	@Override
	public NameValueBean getSeriesName() {
		return name;
	}

	@Override
	public boolean isSetSeriesRepositoryLocation() {
		return !StringUtils.isEmpty(seriesRepoLocation);
	}
	
	@Override
	public void setSeriesRepositoryLocation(String value) {
		seriesRepoLocation = value;
	}
	
	@Override
	public void unsetSeriesRepositoryLocation() {
		seriesRepoLocation = null;
	}
	
	@Override
	public String getSeriesRepositoryLocation() {
		return StringUtils.defaultString(seriesRepoLocation);
	}
	
	@Override
	public boolean internalIsSet() {
		return name.isSet() || description.isSet() || !StringUtils.isEmpty(seriesRepoLocation);
	}
}