package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.ImageBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class ImageBeanImpl extends UnsettableDdiBeanImpl implements ImageBean {

	private Integer dpi;
	private String lang;
	private String type;

	public ImageBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		dpi = null;
		lang = null;
		type = null;
	}

	@Override
	public int getDpi() {
		return (dpi != null) ? dpi.intValue() : 0;
	}

	@Override
	public void setDpi(int value) {
		dpi = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetDpi() {
		return dpi != null;

	}

	@Override
	public String getLang() {
		return StringUtils.defaultString(lang);
	}

	@Override
	public void setLang(String value) {
		lang = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetLang() {
		return !StringUtils.isEmpty(lang);
	}

	@Override
	public String getType() {
		return StringUtils.defaultString(type);
	}

	@Override
	public void setType(String value) {
		this.type = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetType() {
		return !StringUtils.isEmpty(type);
	}

	@Override
	protected boolean internalIsSet() {
		return dpi!=null || !StringUtils.isEmpty(type);
	}
}
