package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.DataFileIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.StatisticalDataFileReferenceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;

public class StatisticalDataFileReferenceBeanImpl extends UnsettableDdiBeanImpl
		implements StatisticalDataFileReferenceBean {

	private boolean inline;
	private ReferenceBeanImpl<DataFileIdentificationBean> dataFileRef;

	public StatisticalDataFileReferenceBeanImpl(IdentifiableBean referrer,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		inline = false;
		dataFileRef = new ReferenceBeanImpl<DataFileIdentificationBean>(
				DataFileIdentificationBean.class, this.getBeanFactory(), this);
	}

	@Override
	public void setInline(boolean inline) {
		this.inline = inline;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isInline() {
		return inline;
	}

	public ReferenceBeanImpl<DataFileIdentificationBean> getDataFileReference() {
		return dataFileRef;
	}

	@Override
	public void setDataFileIdentification(DataFileIdentificationBean dataFileID)
		 {
		dataFileRef.setReferenceTo(dataFileID);
	}

	@Override
	public String getDataFileIdentificationUrn() {
		return dataFileRef.getUrn();
	}

	@Override
	public DataFileIdentificationBean getDataFileIdentification() {
		try {
			return dataFileRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	protected boolean internalIsSet() {
		return dataFileRef.isSet();
	}
}
