package org.openmetadata.beans.ddi.lifecycle.physicalinstance;

import org.openmetadata.datacube.DimensionKey;

public enum SummaryStatisticTypeDimension implements DimensionKey<SummaryStatisticTypeDimension> {
	
	MEAN, 
	MODE,
	MEDIAN,
	VALIDCLASES,
	INVALIDCASES,
	MINIMUM,
	MAXIMUM,
	STANDARD_DEVIATION,
	
	FIRST_QUARTILE,
	THIRD_QUARTILE,
	
	FIRST_QUINTILE,
	SECOND_QUINTILE,
	THIRD_QUINTILE,
	FOURTH_QUINTILE,
	
	FIRST_DECILE,
	SECOND_DECILE,
	THIRD_DECILE,
	FOURTH_DECILE,
	FIFTH_DECILE,
	SIXTH_DECILE,
	SEVENTH_DECILE,
	EIGHT_DECILE,
	NINTH_DECILE,
	
	USE_OTHER;
	
	private SummaryStatisticTypeDimension() {
		
	}

	@Override
	public SummaryStatisticTypeDimension getValue() {
		return this;
	}

	@Override
	public String getType() {
		return SummaryStatisticTypeDimension.class.getName()+"."+toString();
	}

	@Override
	public Class<? extends DimensionKey<?>> getTypeClass() {
		return SummaryStatisticTypeDimension.class;
	}

	@Override
	public String getTextValue() {
		return toString();
	}
}
