package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.impl.DdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.IntervalBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LevelBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CategoryRelationCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class LevelBeanImpl extends DdiBeanImpl implements LevelBean {

	private String name = "";
	private StructuredStringValueBeanImpl description;
	private int levelNumber;
	private IntervalBeanImpl interval;
	private CategoryRelationCode relationshipType;

	public LevelBeanImpl(MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory, ChangeListener listener) {
		super(beanInitializer, factory, listener);

		description = new StructuredStringValueBeanImpl(factory, this);

		interval = new IntervalBeanImpl(factory, this);
	}

	@Override
	public String getName() {
		return StringUtils.defaultString(this.name);
	}

	@Override
	public void setName(String name) {
		this.name = name;
		this.ddiBeanChanged();
	}

	@Override
	public StructuredStringValueBean getDescription() {
		return this.description;
	}
	
	@Override
	public int getLevelNumber() {
		return this.levelNumber;
	}
	
	@Override
	public void setLevelNumber(int value) {
		this.levelNumber = value;
		this.ddiBeanChanged();
	}

	@Override
	public IntervalBean getInterval() {
		return this.interval;
	}

	@Override
	public boolean isSetRelationshipType() {
		return relationshipType != null;
	}

	@Override
	public CategoryRelationCode getRelationshipType() {
		if (relationshipType != null) {
			return relationshipType;
		} else {
			// TODO to decide which one to use as default
			// TODO need to look into the schema
			return CategoryRelationCode.INTERVAL;
		}
	}

	@Override
	public void setRelationshipType(CategoryRelationCode code) {
		this.relationshipType = code;
		this.ddiBeanChanged();
	}

	@Override
	public void unsetRelationshipType() {
		this.relationshipType = null;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSet() {
		return true;
	}

	@Override
	public void unset() {

	}
}
