package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeList;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.CreationEvent;

public class CodeListImpl extends DdiBeanListImpl<CodeBean> implements
		CodeList<CodeBean> {

	private final CodeSchemeBean codeScheme;
	private final MutableBeanInitializer beanInitializer;
	private final ChangeListener changeListener;

	public CodeListImpl(CodeSchemeBean codeScheme,
			MutableBeanInitializer beanInitializer, DdiBeanFactory factory,
			ChangeListener changeListener) {
		super(CodeBean.class, beanInitializer, factory, changeListener);
		this.codeScheme = codeScheme;
		this.beanInitializer = beanInitializer;
		this.changeListener = changeListener;
	}

	public void internalAddCode(CodeBean code) {
		this.add(code);
	}

	@Override
	protected final CodeBean createNew() {
		return new CodeBeanImpl("0", codeScheme, beanInitializer,
				this.getBeanFactory(), changeListener);
	}

	@Override
	public boolean contains(String codeVal) {
		CodeBean code = this.getCode(codeVal);
		return code != null;
	};

	@Override
	public CodeBean getCode(String codeVal) {
		if (codeVal != null) {
			List<CodeBean> list = this.getInternalList();
			for (CodeBean code : list) {
				if (code != null) {
					String val = code.getValue();
					if (val.equals(codeVal)) {
						return code;
					}
				}
			}
		}
		return null;
	}

	@Override
	public void changeCode(String oldValue, String newValue) {
		CodeBean oldCode = this.getCode(oldValue);
		if (oldCode != null && oldCode.getValue().equals(newValue) == false) {
			CategoryBean referredCategory = oldCode.getCategory();
			codeScheme.getCodeList().remove(oldCode);
			CodeBean newCode = codeScheme.getCodeList().addNew(newValue);
			newCode.setCategory(referredCategory);
		}
	}

	@Override
	public final CodeBean addNew(CategoryBean category, String codeVal) {
		if (this.contains(codeVal) == false) {

			CodeBeanImpl code = new CodeBeanImpl(codeVal, codeScheme,
					beanInitializer, this.getBeanFactory(), changeListener);
			code.setCategory(category);

			this.add(code);
			this.notifyChange(new CreationEvent(code));
			return code;
		} else {
			return null;
		}
	}

	@Override
	public CodeBean addNew(String codeVal) {
		if (this.contains(codeVal) == false) {
			CodeBean code = new CodeBeanImpl(codeVal, codeScheme,
					beanInitializer, this.getBeanFactory(), changeListener);

			this.add(code);
			this.notifyChange(new CreationEvent(code));
			return code;
		} else {
			return null;
		}
	}

	@Override
	public boolean remove(CodeBean bean) {
		if (bean != null) {
			bean.removeAllReferences();
			return super.remove(bean);
		} else {
			return false;
		}
	};
}