package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataSourceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.OriginBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DataSourceBeanImpl extends UnsettableDdiBeanImpl implements DataSourceBean{
	
	private StructuredStringValueBean sourceDescription;
	private DdiBeanList<CodeValueBean> sourceTypeList;
	private DdiBeanList<OriginBean> originList;
	private StructuredStringValueBean characteristic;

	public DataSourceBeanImpl(
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		
		sourceDescription = new StructuredStringValueBeanImpl(beanFactory, this);
		
		sourceTypeList = new DdiBeanListImpl<CodeValueBean>(CodeValueBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected CodeValueBean createNew() {
				return new CodeValueBeanImpl(DataSourceBeanImpl.this.getBeanFactory(), DataSourceBeanImpl.this);
			}
		};
		
		originList = new DdiBeanListImpl<OriginBean>(OriginBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected OriginBean createNew() {
				return new OriginBeanImpl(
						beanInitializer,
						DataSourceBeanImpl.this.getBeanFactory(), DataSourceBeanImpl.this);
			}
		};
		
		characteristic = new StructuredStringValueBeanImpl(beanFactory, this);
	}

	@Override
	public StructuredStringValueBean getSourceDescription() {
		return sourceDescription;
	}

	@Override
	public DdiBeanList<CodeValueBean> getSourceTypeList() {
		return sourceTypeList;
	}

	@Override
	public DdiBeanList<OriginBean> getOriginList() {
		return originList;
	}

	@Override
	public StructuredStringValueBean getCharacteristic() {
		return characteristic;
	}

	@Override
	protected boolean internalIsSet() {
		return sourceDescription.isSet() || sourceTypeList.size()>0 || originList.size()>0 || characteristic.isSet();
	}

}
