package org.openmetadata.beans.ddi.lifecycle.adt;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.UnsettableDdiBean;

public interface KeyedValueBean<B extends KeyedBean> extends UnsettableDdiBean {

	/**
	 * Returns all the elements whose attribute match to the keys of the query
	 * parameter. If no match is found, it will return the empty array.
	 * 
	 * @param query
	 * @return the elements with the keys that match the keys of the given query
	 */
	B[] findBeans(Map<Enum<?>, Object> query);

	/**
	 * Returns the element where the associated keys match to the keys of the
	 * query parameter. If no match is found, it will create a new element with
	 * the given keys and return the element.
	 * 
	 * @param query
	 * @return the existing or newly created element with the keys that match
	 *         the keys of the given query
	 */
	B getBean(Map<Enum<?>, Object> keys);

	/**
	 * Removes all of the elements from this value bean. The value bean will be
	 * empty after this call returns.
	 */
	void removeAll();

	/**
	 * Removes all of the elements from this value bean where the keys of the
	 * elements match the keys given as a query. The value bean will be empty
	 * after this call returns.
	 */
	void removeAll(Map<Enum<?>, Object> query);

	void remove(Map<Enum<?>, Object> query);

	int size();

	B[] getAllValues();
}
