/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CaseIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalRecordBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CaseIdentificationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariablesInRecordBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class LogicalRecordBeanImpl
extends AbstractIdentifiableBeanImpl
implements LogicalRecordBean {
    private Integer variableQuantity;
    private boolean hasLocator = false;
    private final VariablesInRecordBeanImpl varsInRecord;
    private final DdiBeanListImpl<CaseIdentificationBean> caseIdentificationList;

    public LogicalRecordBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.caseIdentificationList = new DdiBeanListImpl<CaseIdentificationBean>(CaseIdentificationBean.class, beanInitializer, factory, (ChangeListener)this){

            @Override
            protected CaseIdentificationBean createNew() {
                return new CaseIdentificationBeanImpl(this.getBeanFactory(), this);
            }
        };
        this.varsInRecord = new VariablesInRecordBeanImpl(beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetVariablesInRecord(String[] urns) {
        this.varsInRecord.initSetVariableUsedUrns(urns);
    }

    @Override
    public boolean getHasLocator() {
        return this.hasLocator;
    }

    @Override
    public void setHasLocator(boolean hasLocator) {
        if (this.hasLocator != hasLocator) {
            this.hasLocator = hasLocator;
            this.change();
        }
    }

    @Override
    public int getVariableQuantity() {
        if (this.isSetVariableQuantity()) {
            return this.variableQuantity;
        }
        return 0;
    }

    @Override
    public void setVariableQuantity(int value) {
        if (CompareUtil.areDifferentValues(this.variableQuantity, value)) {
            this.variableQuantity = value;
            this.change();
        }
    }

    @Override
    public boolean isSetVariableQuantity() {
        return this.variableQuantity != null;
    }

    @Override
    public VariablesInRecordBeanImpl getVariablesInRecord() {
        return this.varsInRecord;
    }

    @Override
    public DdiBeanList<CaseIdentificationBean> getCaseIdentifications() {
        return this.caseIdentificationList;
    }

    @Override
    public void doChangeReference(IdentifiableBean toDerefer, IdentifiableBean toRefer) {
        if (toDerefer instanceof VariableBean && toRefer instanceof VariableBean) {
            VariableBean toDereferVar = (VariableBean)toDerefer;
            if (((ReferenceSetImpl)this.varsInRecord.getUsedVariableList()).contains(toDereferVar)) {
                ((ReferenceSetImpl)this.varsInRecord.getUsedVariableList()).remove(toDereferVar);
                VariableBean toReferVar = (VariableBean)toRefer;
                ((ReferenceSetImpl)this.varsInRecord.getUsedVariableList()).add(toReferVar);
            }
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        if (toRemove instanceof VariableBean) {
            VariableBean toRemoveVar = (VariableBean)toRemove;
            if (((ReferenceSetImpl)this.varsInRecord.getUsedVariableList()).contains(toRemoveVar)) {
                ((ReferenceSetImpl)this.varsInRecord.getUsedVariableList()).remove(toRemoveVar);
            }
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.LogicalRecord;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return LogicalRecordBean.class;
    }
}

