package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.SummaryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class SummaryStatisticBeanImpl extends UnsettableDdiBeanImpl implements
		SummaryStatisticBean {

	private CodeValueBeanImpl summaryStatType;
	private boolean weighted;
	private double value;

	public SummaryStatisticBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		summaryStatType = new CodeValueBeanImpl(factory, this);

		weighted = false;
		value = 0;
	}

	@Override
	public CodeValueBeanImpl getSummaryStatisticType() {
		return summaryStatType;
	}

	@Override
	public void setWeighted(boolean weighted) {
		this.weighted = weighted;
		this.ddiBeanChanged();
	}

	@Override
	public boolean getWeighted() {
		return weighted;
	}

	@Override
	public void setValue(double value) {
		this.value = value;
		this.ddiBeanChanged();
	}

	@Override
	public double getValue() {
		return value;
	}
	
	@Override
	protected boolean internalIsSet() {
		return true;
	}
}
