package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.StatisticalDataFileReferenceBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.StatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.VariableStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class StatisticsBeanImpl extends UnsettableDdiBeanImpl implements
		StatisticsBean {

	//private final IdentifiableBean referrer;

	private DdiBeanListImpl<VariableStatisticsBean> varStatList;
	private DdiBeanListImpl<StatisticalDataFileReferenceBean> statDataFileRefList;

	public StatisticsBeanImpl(final IdentifiableBean referrer,
			final MutableBeanInitializer beanInitializer, 
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		//this.referrer = referrer;
		varStatList = new DdiBeanListImpl<VariableStatisticsBean>(
				VariableStatisticsBean.class, beanInitializer, factory, this) {
			@Override
			protected VariableStatisticsBean createNew() {
				return new VariableStatisticsBeanImpl(
						beanInitializer,
						StatisticsBeanImpl.this.getBeanFactory(),
						StatisticsBeanImpl.this);
			}
		};
		statDataFileRefList = new DdiBeanListImpl<StatisticalDataFileReferenceBean>(
				StatisticalDataFileReferenceBean.class, beanInitializer, factory, this) {
			@Override
			protected StatisticalDataFileReferenceBean createNew() {
				return new StatisticalDataFileReferenceBeanImpl(referrer,
						StatisticsBeanImpl.this.getBeanFactory(),
						StatisticsBeanImpl.this);
			};
		};
	}

	@Override
	public DdiBeanList<StatisticalDataFileReferenceBean> getStatisticalDataFileReferences() {
		return statDataFileRefList;
	}

	@Override
	public DdiBeanList<VariableStatisticsBean> getVariableStatistics() {
		return varStatList;
	}

	@Override
	protected boolean internalIsSet() {
		return varStatList.size()>0 || statDataFileRefList.size()>0;
	}

	/*
	 * @Override public StatisticsType getDdi3XmlObject() throws
	 * DdiValidationException { StatisticsType stat = super.getDdi3XmlObject();
	 * 
	 * stat.getStatisticalDataFileReferenceList().clear();
	 * stat.getStatisticalDataFileReferenceList
	 * ().addAll(this.statDataFileRefList.getDdi3XmlObjectList());
	 * 
	 * stat.getVariableStatisticsList().clear();
	 * stat.getVariableStatisticsList()
	 * .addAll(this.varStatList.getDdi3XmlObjectList());
	 * 
	 * return stat; }
	 * 
	 * @Override protected StatisticsType createDdi3XmlObject() { return
	 * StatisticsType.Factory.newInstance(); }
	 * 
	 * @Override protected SchemaType getSchemaType() { return
	 * StatisticsType.type; }
	 */

}
