package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.GrossFileStructureBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.SoftwareBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class GrossFileStructureBeanImpl extends AbstractIdentifiableBeanImpl
		implements GrossFileStructureBean {

	private String placeOfProduction = null;
	private String processingStatus = null;
	private Integer caseQuantity = null;
	private Integer overallRecordCount = null;
	private StructuredStringValueBeanImpl processingCheck;

	public GrossFileStructureBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
	}

	@Override
	public boolean isSetPlaceOfProduction() {
		return placeOfProduction != null;
	}

	@Override
	public void setPlaceOfProduction(String value) {
		if (CompareUtil.areDifferentValues(this.placeOfProduction, value)) {
			placeOfProduction = value;
			this.change();
		}
	}

	@Override
	public String getPlaceOfProduction() {
		if (placeOfProduction != null) {
			return placeOfProduction;
		} else {
			return "";
		}
	}

	@Override
	public StructuredStringValueBeanImpl getProcessingCheck() {
		if (processingCheck == null) {
			processingCheck = new StructuredStringValueBeanImpl(
					this.getBeanFactory(), this);
		}
		return processingCheck;
	}

	@Override
	public boolean isSetProcessingStatus() {
		return processingStatus != null;
	}

	@Override
	public void setProcessingStatu(String value) {
		if (CompareUtil.areDifferentValues(this.processingStatus, value)) {
			processingStatus = value;
			this.change();
		}
	}

	@Override
	public String getProcessingStatus() {
		return processingStatus;
	}

	@Deprecated
	@Override
	public boolean isSetCreationSoftware() {
		return false;
	}

	@Deprecated
	@Override
	public void unsetCreationSoftware() {
		// software = null;
	}

	@Deprecated
	@Override
	public SoftwareBeanImpl getCreationSoftware() {
		return null;
	}

	@Override
	public boolean isSetCaseQuantity() {
		return caseQuantity != null;
	}

	@Override
	public void setCaseQuantity(int value) {
		if (CompareUtil.areDifferentValues(this.caseQuantity, value)) {
			caseQuantity = value;
			this.change();
		}
	}

	@Override
	public int getCaseQuantity() {
		if (caseQuantity != null) {
			return caseQuantity;
		} else {
			return 0;
		}
	}

	@Override
	public boolean isSetOverallRecordCount() {
		return overallRecordCount != null;
	}

	@Override
	public void setOverallRecordCount(int value) {
		if (CompareUtil.areDifferentValues(this.overallRecordCount, value)) {
			overallRecordCount = value;
			this.change();
		}
	}

	@Override
	public int getOverallRecordCount() {
		if (overallRecordCount != null) {
			return overallRecordCount;
		} else {
			return 0;
		}
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub

	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.GrossFileStructure;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return GrossFileStructureBean.class;
	}

}
