package org.openmetadata.beans.ddi.lifecycle.physicalinstance;

import org.openmetadata.datacube.DimensionKey;

public enum IsWeightedDimension implements DimensionKey<Boolean> {
	TRUE(true), FALSE(false);
	
	private boolean booleanVal;
	
	IsWeightedDimension(boolean booleanVal) {
		this.booleanVal = booleanVal;
	}

	@Override
	public Boolean getValue() {
		return booleanVal;
	}

	@Override
	public String getType() {
		return IsWeightedDimension.class.getName();
	}

	@Override
	public Class<? extends DimensionKey<?>> getTypeClass() {
		return IsWeightedDimension.class;
	}

	@Override
	public String getTextValue() {
		return toString();
	}
}
