package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalStructureSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class PhysicalDataProductBeanImpl extends AbstractMaintainableBeanImpl
		implements PhysicalDataProductBean {

	ReferenceSetImpl<RecordLayoutSchemeBean> recordLayoutSchemes;
	ReferenceSetImpl<PhysicalStructureSchemeBean> phyStructSchemes;

	public PhysicalDataProductBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		recordLayoutSchemes = new ReferenceSetImpl<RecordLayoutSchemeBean>(
				RecordLayoutSchemeBean.class, beanInitializer, factory, this);
		phyStructSchemes = new ReferenceSetImpl<PhysicalStructureSchemeBean>(
				PhysicalStructureSchemeBean.class, beanInitializer, factory, this);
	}

	public void initSetRecordLayoutSchemes(String[] urns) {
		recordLayoutSchemes.initReferenceUrns(urns);
	}

	public void initSetPhysicalStructureSchemes(String[] urns) {
		phyStructSchemes.initReferenceUrns(urns);
	}

	@Override
	public ReferenceSetImpl<PhysicalStructureSchemeBean> getPhysicalStructureSchemeList() {
		return this.phyStructSchemes;
	}

	@Override
	public ReferenceSetImpl<RecordLayoutSchemeBean> getRecordLayoutSchemeList() {
		return this.recordLayoutSchemes;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.PhysicalDataProduct;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return PhysicalDataProductBean.class;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}
}
