package org.openmetadata.beans.ddi.lifecycle.notification;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.beans.notification.ChangeEvent;

public class ReferenceRemovedEvent implements ReferenceChangeEvent {

	private Set<String> removedReferences = new HashSet<String>();

	public ReferenceRemovedEvent(String deleted) {
		if (deleted != null) {
			removedReferences.add(deleted);
		}
	}

	public ReferenceRemovedEvent(Set<String> deleted) {
		removedReferences.addAll(deleted);
	}

	@Override
	public ChangeEvent[] getInitiatingEvents() {
		return new ChangeEvent[0];
	}

	@Override
	public Type getType() {
		return Type.UPDATE;
	}

	@Override
	public Set<String> getAddedReferences() {
		return new HashSet<String>();
	}

	@Override
	public Set<String> getRemovedReferences() {
		return removedReferences;
	}
}
