package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableGroupBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class VariableSchemeBeanImpl extends AbstractMaintainableBeanImpl
		implements VariableSchemeBean {

	protected ReferenceSetImpl<VariableSchemeBean> schemeReferenceList;
	protected InitializingSchemeItemList<VariableBean> variableList;
	protected InitializingSchemeItemList<VariableGroupBean> variableGroupList;

	public VariableSchemeBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		schemeReferenceList = new ReferenceSetImpl<VariableSchemeBean>(
				VariableSchemeBean.class, beanInitializer, factory, this);
		variableList = new ResolvingSchemeItemListImpl<VariableBean>(this.getUrn(),
				VariableBean.class, beanInitializer, factory, this);
		variableGroupList = new ResolvingSchemeItemListImpl<VariableGroupBean>(
				this.getUrn(), VariableGroupBean.class, beanInitializer, factory, this);
	}

	public void initSetVariables(String[] urns) {
		variableList.initSetIdentifiableUrns(urns);
	}

	public void initSetVariableGroups(String[] urns) {
		variableGroupList.initSetIdentifiableUrns(urns);
	}

	@Override
	public ReferenceSetImpl<VariableSchemeBean> getVariableSchemeList() {
		return schemeReferenceList;
	}
	
	protected void setVariableList(
			InitializingSchemeItemList<VariableBean> variableList) {
		this.variableList = variableList;
	}

	@Override
	public InitializingSchemeItemList<VariableBean> getVariableList() {
		return variableList;
	}
	
	protected void setVariableGroupList(
			InitializingSchemeItemList<VariableGroupBean> variableGroupList) {
		this.variableGroupList = variableGroupList;
	}

	@Override
	public InitializingSchemeItemList<VariableGroupBean> getVariableGroupList() {
		return variableGroupList;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.VariableScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return VariableSchemeBean.class;
	}
}
