package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.VersionBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class VersionBeanImpl extends UnsettableDdiBeanImpl implements
		VersionBean {

	private String value;

	public VersionBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		value = "1.0.0";
	}

	@Override
	public String getStringValue() {
		return value;
	}

	@Override
	public void setStringValue(String value) {
		this.value = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean internalIsSet() {
		return !StringUtils.isEmpty(value);
	}
}
