package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CoverageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.TopicalCoverageBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class CoverageBeanImpl extends UnsettableDdiBeanImpl implements
		CoverageBean {

	private TemporalCoverageBeanImpl temporalCoverage;
	private TopicalCoverageBeanImpl topicalCoverage;
	private GeographicCoverageBeanImpl geographicCoverage;
	
	public CoverageBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory, ChangeListener listener) {
		super(beanFactory, listener);
		temporalCoverage = new TemporalCoverageBeanImpl(beanInitializer, beanFactory, this);
		topicalCoverage = new TopicalCoverageBeanImpl(beanInitializer, beanFactory, this);
		geographicCoverage = new GeographicCoverageBeanImpl(beanInitializer, beanFactory, this);
	}

	@Override
	public TemporalCoverageBeanImpl getTemporalCoverage() {
		return temporalCoverage;
	}
	
	@Override
	public TopicalCoverageBean getTopicalCoverage() {
		return topicalCoverage;
	}
		
	@Override
	protected boolean internalIsSet() {
		return temporalCoverage.internalIsSet()
				|| topicalCoverage.internalIsSet()
				|| geographicCoverage.isSet();
	}

	@Override
	public GeographicCoverageBeanImpl getSpatialCoverage() {
		return geographicCoverage;
	}
}