package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariablesInRecordBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class VariablesInRecordBeanImpl extends UnsettableDdiBeanImpl implements
		VariablesInRecordBean {

	private Boolean allVariablesInLogicalProduct;
	private ReferenceSetImpl<VariableBean> varUsedRefs;

	public VariablesInRecordBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		varUsedRefs = new ReferenceSetImpl<VariableBean>(VariableBean.class, beanInitializer,
				factory, this);
	}

	public void initSetVariableUsedUrns(String[] urns) {
		varUsedRefs.initReferenceUrns(urns);
	}

	@Override
	public boolean isAllVariablesInLogicalProduct() {
		if (allVariablesInLogicalProduct != null) {
			return allVariablesInLogicalProduct;
		} else {
			return false;
		}
	}

	@Override
	public void setAllVariablesInLogicaProduct(boolean all) {
		if (CompareUtil.areDifferentValues(this.allVariablesInLogicalProduct,
				all)) {
			allVariablesInLogicalProduct = all;
			this.ddiBeanChanged();
		}
	}

	@Override
	public ReferenceSetImpl<VariableBean> getUsedVariableList() {
		return varUsedRefs;
	}

	@Override
	protected boolean internalIsSet() {
		return varUsedRefs.size() > 0;
	}
}
