package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class StatementItemBeanImpl extends ControlConstructBeanImpl implements
		StatementItemBean {

	private DynamicTextValueBeanImpl displayText;

	public StatementItemBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		displayText = new DynamicTextValueBeanImpl(factory, this);
	}

	@Override
	public DynamicTextValueBeanImpl getDisplayText() {
		return displayText;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.StatementItem;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return StatementItemBean.class;
	}
}