package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.archive.InstantMessagingBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class InstantMessagingBeanImpl extends UnsettableDdiBeanImpl implements
		InstantMessagingBean {

	private String stringValue;
	private String type;

	public InstantMessagingBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		stringValue = null;
	}

	@Override
	public String getStringValue() {
		return StringUtils.defaultString(stringValue);
	}

	@Override
	public void setStringValue(String value) {
		stringValue = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetType() {
		return type != null;
	}

	@Override
	public String getType() {
		return StringUtils.defaultString(type);
	}

	@Override
	public void setType(String value) {
		this.type = value;
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}
}
