package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.Collection;
import java.util.Iterator;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.reference.Resolver;

public class DynamicIdentifiableIterator<B extends IdentifiableBean> implements
		Iterator<B> {

	private final Iterator<String> urnCollIterator;
	private final Resolver resolver;
	private final Class<? extends B> beanClass;
	
	public DynamicIdentifiableIterator(Collection<String> urnColl,
			Class<? extends B> beanClass2, Resolver resolver) {
		this.urnCollIterator = urnColl.iterator();
		this.resolver = resolver;
		this.beanClass = beanClass2;
	}

	@Override
	public boolean hasNext() {
		return urnCollIterator.hasNext();
	}

	@Override
	public B next() {
		String urn = urnCollIterator.next();
		if (urn != null) {
			B identifiableBean;
			try {
				identifiableBean = (B) resolver.resolve(beanClass, urn);
				return identifiableBean;
			} catch (org.openmetadata.beans.exceptions.ResolverException e) {
				e.printStackTrace();
				return null;
			}
		} else {
			return null;
		}
	}

	@Override
	public void remove() {
		// do nothing since it is irrelevant operation.
	}
}
