package org.openmetadata.beans.ddi.lifecycle.adt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.reference.Resolver;

public class ResolvingSet<B extends IdentifiableBean> implements Iterable<B>{
	private Logger logger = Logger.getLogger(ResolvingSet.class);
	
	private Set<String> urnSet = new HashSet<String>();
	private Resolver resolver;
	private Class<B> beanClass;
	
	public ResolvingSet(Set<String> urnSet, Class<B> beanClass, Resolver resolver){
		this.urnSet.addAll(urnSet);
		this.resolver = resolver;
	}
	
	public int size(){
		return urnSet.size();
	}
	
	public String[] getIDs(){
		return urnSet.toArray(new String[0]);
	}
	
	public B[] toArray(){
		List<B> list = new ArrayList<B>();
		for(B bean : this){
			list.add(bean);
		}
		@SuppressWarnings("unchecked")
		B[] typeArr = (B[]) Array.newInstance(beanClass,0);		
		return list.toArray(typeArr);
	}
	
	@Override
	public Iterator<B> iterator() {
		List<B> list = new ArrayList<B>();
		for(String urn : this.urnSet){
			try {
				B bean = resolver.resolve(beanClass, urn);
				list.add(bean);
			} catch (ResolverException e) {
				logger.error(e.getMessage(), e);
				return (new ArrayList<B>()).iterator();
			}
		}
		return list.iterator();
	}
}
