package org.openmetadata.beans.ddi.lifecycle.adt;

import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;

public interface DirectedEdge<B extends IdentifiableBean> {
	/**
	 * Return the object where this edge begins.
	 * @return
	 */
	B getSource();

	/**
	 * Return the URN of the object where this edge begins.
	 * @return
	 */
	String getSourceUrn();

	/**
	 * Return the object where this edge ends.
	 * @return
	 */
	B getTarget();

	/**
	 * Return the URN of the object where this edge begins.
	 * @return
	 */
	String getTargetUrn();
}
