package org.openmetadata.beans.ddi.lifecycle.adt;

import java.util.Comparator;

import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;

/**
 * An order collection of <code>DdiBean</code> objects.
 * 
 * @author Kyaw Soe
 * 
 * @param <B>
 */
public interface DdiBeanList<B extends DdiBean> extends DdiBean, Iterable<B> {

	/**
	 * Create and insert a new element to the end of the list.
	 * 
	 * @return the newly created element
	 */
	public B addNew();

	boolean contains(B bean);

	/**
	 * Removes the first occurrence of the specified element from this list.
	 * 
	 * @param bean
	 * @return Returns <code>true</code> if the element is successfully removed
	 *         from this list.
	 */
	boolean remove(B bean);

	int size();

	void moveBefore(B move, B before);

	void moveAfter(B move, B after);

	void sort(Comparator<B> comparator);

	/**
	 * Returns an array containing all of the elements in this list in proper
	 * sequence (from first to last element).
	 * 
	 * @return
	 */
	B[] toArray();
}
