/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.beans.ddi.lifecycle.types.XmlDateDataType;

public enum DateDataFormat {
    MONTH_DAY_YEAR2D_SLASH("yyyy", "MM/yyyy", "MM/dd/yy", "MM/dd/yy HH:mm:ss"),
    DAY_MONTH_YEAR2D_SLASH("yyyy", "MM/yyyy", "dd/MM/yy", "dd/MM/yy HH:mm:ss"),
    DAY_MONTH_YEAR4D_SLASH("yyyy", "MM/yyyy", "dd/MM/yyyy", "dd/MM/yyyy HH:mm:ss"),
    YEAR4D_MONTH_DAY_SLASH("yyyy", "yyyy/MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss"),
    MONTH_DAY_YEAR4D_DASH("yyyy", "MM-yyyy", "MM-dd-yyyy", "MM-dd-yyyy HH:mm:ss");

    private final Map<XmlDateDataType, String> map = new HashMap<XmlDateDataType, String>();

    private DateDataFormat(String yearPattern, String monthyearPattern, String datePattern, String datetimePattern) {
        this.map.put(XmlDateDataType.DATE, datePattern);
        this.map.put(XmlDateDataType.DATETIME, datetimePattern);
        this.map.put(XmlDateDataType.GYEAR, yearPattern);
        this.map.put(XmlDateDataType.GYEARMONTH, monthyearPattern);
    }

    public Date parseDate(String formattedStr, XmlDateDataType dateType) throws ParseException {
        String pattern = this.map.get((Object)dateType);
        SimpleDateFormat simDateFormat = new SimpleDateFormat(pattern);
        Date date = simDateFormat.parse(formattedStr);
        return date;
    }

    public boolean validate(String formattedDateStr, XmlDateDataType dateType) {
        try {
            String pattern = this.map.get((Object)dateType);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            Date date = simpleDateFormat.parse(formattedDateStr);
            String reconstructedStr = simpleDateFormat.format(date);
            return formattedDateStr.equals(reconstructedStr);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String getFormattedString(XmlDateDataType xmlDateDataType, Date date) {
        String pattern = this.map.get((Object)xmlDateDataType);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }
}

