/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticQuery;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.InstanceDatasetBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.SummaryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.SummaryStatisticQuery;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.VariableStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class InstanceDatasetBeanImpl
extends UnsettableDdiBeanImpl
implements InstanceDatasetBean {
    private Map<String, Set<SummaryStatisticBean>> var2SummaryStatMap = new HashMap<String, Set<SummaryStatisticBean>>();
    private Map<String, Set<CategoryStatisticsBean>> var2CategoryStatsMap = new HashMap<String, Set<CategoryStatisticsBean>>();

    public InstanceDatasetBeanImpl(DdiBeanFactory beanFactory, ChangeListener changeListener) {
        super(beanFactory, changeListener);
    }

    public void initSetSummaryStatistics(VariableStatisticsBean[] varStatsArray) {
        this.var2SummaryStatMap.clear();
        VariableStatisticsBean[] variableStatisticsBeanArray = varStatsArray;
        int n = varStatsArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableStatisticsBean varStats = variableStatisticsBeanArray[n2];
            String variableUrn = varStats.getVariableUrn();
            for (SummaryStatisticBean summaryStats : varStats.getSummaryStatisticList()) {
                if (!this.var2SummaryStatMap.containsKey(variableUrn)) {
                    this.var2SummaryStatMap.put(variableUrn, new HashSet());
                }
                this.var2SummaryStatMap.get(variableUrn).add(summaryStats);
            }
            for (CategoryStatisticsBean ctgStats : varStats.getCategoryStatisticsList()) {
                if (!this.var2CategoryStatsMap.containsKey(variableUrn)) {
                    this.var2CategoryStatsMap.put(variableUrn, new HashSet());
                }
                this.var2CategoryStatsMap.get(variableUrn).add(ctgStats);
            }
            ++n2;
        }
    }

    @Override
    public SummaryStatisticBean[] getSummaryStatistics(SummaryStatisticQuery query) {
        VariableBean variable;
        if (query.isSetVariable() && this.var2SummaryStatMap.containsKey((variable = query.getVariable()).getUrn())) {
            Set<SummaryStatisticBean> statsForVar = this.var2SummaryStatMap.get(variable.getUrn());
            HashSet<SummaryStatisticBean> statsForVarWithRequiredWeight = new HashSet<SummaryStatisticBean>();
            for (SummaryStatisticBean stat : statsForVar) {
                if (stat.getWeighted() != query.getIsWeighted()) continue;
                statsForVarWithRequiredWeight.add(stat);
            }
            return statsForVarWithRequiredWeight.toArray(new SummaryStatisticBean[0]);
        }
        return new SummaryStatisticBean[0];
    }

    @Override
    public CategoryStatisticBean[] getCategoryStatistics(CategoryStatisticQuery query) {
        VariableBean variable;
        if (query.isSetVariable() && this.var2CategoryStatsMap.containsKey((variable = query.getVariable()).getUrn())) {
            Set<CategoryStatisticsBean> statsForVarSet = this.var2CategoryStatsMap.get(variable.getUrn());
            HashSet<CategoryStatisticBean> result = new HashSet<CategoryStatisticBean>();
            for (CategoryStatisticsBean statsForVar : statsForVarSet) {
                for (CategoryStatisticBean categoryStat : statsForVar.getCategoryStaticList()) {
                    boolean weightPropMatch;
                    String currStatType = categoryStat.getCategoryStatisticType().getStringValue();
                    boolean typeMatch = currStatType.equalsIgnoreCase(query.getCategoryStatisticType());
                    boolean bl = weightPropMatch = categoryStat.getIsWeighted() == query.getIsWeighted();
                    if (!typeMatch || !weightPropMatch) continue;
                    if (query.isSetCategoryValue()) {
                        if (!categoryStat.getCategoryValue().equalsIgnoreCase(query.getCategoryValue())) continue;
                        result.add(categoryStat);
                        continue;
                    }
                    result.add(categoryStat);
                }
            }
            return result.toArray(new CategoryStatisticBean[0]);
        }
        return new CategoryStatisticBean[0];
    }

    @Override
    protected boolean internalIsSet() {
        return this.var2SummaryStatMap.size() > 0;
    }
}

