/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstructionBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.DynamicTextValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class QuestionItemBeanImpl
extends AbstractSchemeItemBean<QuestionSchemeBean>
implements QuestionItemBean {
    final DynamicTextValueBeanImpl text;
    final ReferenceSetImpl<ConceptBean> conceptReferenceList;
    private final ReferenceSetImpl<InstructionBean> instructionRefSet;

    public QuestionItemBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super((boolean)isNewInstance, urn, beanInitializer, factory);
        this.text = new DynamicTextValueBeanImpl(factory, (ChangeListener)this);
        this.conceptReferenceList = new ReferenceSetImpl<ConceptBean>(ConceptBean.class, beanInitializer, factory, (ChangeListener)this);
        this.instructionRefSet = new ReferenceSetImpl<InstructionBean>(InstructionBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetConcepts(String[] conceptUrns) {
        this.conceptReferenceList.initReferenceUrns(conceptUrns);
    }

    public void initSetInterviewInstructions(String[] interviewInstructionUrns) {
        this.instructionRefSet.initReferenceUrns(interviewInstructionUrns);
    }

    public ReferenceSetImpl<InstructionBean> getInterviewInstructionList() {
        return this.instructionRefSet;
    }

    @Override
    public DynamicTextValueBeanImpl getQuestionText() {
        return this.text;
    }

    public ReferenceSetImpl<ConceptBean> getConceptList() {
        return this.conceptReferenceList;
    }

    @Override
    public void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
        InstructionBean currInstruction;
        if (current instanceof ConceptBean && another instanceof ConceptBean) {
            ConceptBean currConcept = (ConceptBean)current;
            if (this.conceptReferenceList.contains(currConcept)) {
                this.conceptReferenceList.remove(currConcept);
                ConceptBean anotherConcept = (ConceptBean)another;
                this.conceptReferenceList.add(anotherConcept);
            }
        } else if (current instanceof InstructionBean && another instanceof InstructionBean && this.instructionRefSet.contains(currInstruction = (InstructionBean)current)) {
            this.instructionRefSet.remove(currInstruction);
            InstructionBean anotherInstruction = (InstructionBean)another;
            this.instructionRefSet.add(anotherInstruction);
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        InstructionBean currInstruction;
        if (toRemove instanceof ConceptBean) {
            ConceptBean currConcept = (ConceptBean)toRemove;
            if (this.conceptReferenceList.contains(currConcept)) {
                this.conceptReferenceList.remove(currConcept);
            }
        } else if (toRemove instanceof InstructionBean && this.instructionRefSet.contains(currInstruction = (InstructionBean)toRemove)) {
            this.instructionRefSet.remove(currInstruction);
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.QuestionItem;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return QuestionItemBean.class;
    }
}

