/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ControlConstructBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class QuestionConstructBeanImpl
extends ControlConstructBeanImpl
implements QuestionConstructBean {
    private final ReferenceBeanImpl<QuestionItemBean> questionReference;
    private final ReferenceSetImpl<UniverseBean> uniRefSet;

    public QuestionConstructBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.questionReference = new ReferenceBeanImpl<QuestionItemBean>(QuestionItemBean.class, factory, (ChangeListener)this);
        this.uniRefSet = new ReferenceSetImpl<UniverseBean>(UniverseBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetQuestion(String questionItemUrn) throws URNFormatException {
        this.questionReference.setReferenceUrn(questionItemUrn);
    }

    public void initSetUniverses(String[] universeUrns) {
        this.uniRefSet.initReferenceUrns(universeUrns);
    }

    public ReferenceBeanImpl<QuestionItemBean> getQuestionReference() {
        return this.questionReference;
    }

    @Override
    public boolean isSetQuestion() {
        return this.questionReference.isSet();
    }

    @Override
    public void setQuestion(QuestionItemBean question) {
        this.questionReference.setReferenceTo(question);
    }

    @Override
    public String getQuestionUrn() {
        return this.questionReference.getUrn();
    }

    @Override
    public QuestionItemBean getQuestion() {
        try {
            return this.questionReference.getReferredObject();
        }
        catch (ResolverException e) {
            return null;
        }
    }

    public ReferenceSetImpl<UniverseBean> getUniverseList() {
        return this.uniRefSet;
    }

    @Override
    public void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
        UniverseBean currUniverse;
        super.doChangeReference(current, another);
        if (current instanceof UniverseBean && another instanceof UniverseBean && this.uniRefSet.contains(currUniverse = (UniverseBean)current)) {
            this.uniRefSet.remove(currUniverse);
            UniverseBean anotherUniverse = (UniverseBean)another;
            this.uniRefSet.add(anotherUniverse);
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        UniverseBean currUniverse;
        super.doRemoveReference(toRemove);
        if (toRemove instanceof UniverseBean && this.uniRefSet.contains(currUniverse = (UniverseBean)toRemove)) {
            this.uniRefSet.remove(currUniverse);
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.QuestionConstruct;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return QuestionConstructBean.class;
    }
}

