package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.notification.BeanChangeEvent;
import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.reference.Resolver;

public abstract class DdiBeanImpl implements DdiBean, ChangeListener {

	protected boolean empty = false;
	private ChangeListener thisBeanChangeListener;

	private Resolver beanResolver;
	private DdiBeanFactory beanFactory;

	public DdiBeanImpl(
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		if (beanFactory == null) {
			throw new RuntimeException("BeanFactory must not be null");
		}
		if (changeListener == null) {
			throw new RuntimeException("ChangeListener must not be null");
		}

		this.beanResolver = beanInitializer;
		this.beanFactory = beanFactory;
		this.thisBeanChangeListener = changeListener;
	}

	protected void ddiBeanChanged() {
		if (this.thisBeanChangeListener != null) {
			BeanChangeEvent event = new BeanChangeEvent(
					BeanChangeEvent.Type.UPDATE, this);
			this.thisBeanChangeListener.notifyChange(event);
		}
	}

	@Override
	public void notifyChange(ChangeEvent event) {
		if (this.thisBeanChangeListener != null) {
			BeanChangeEvent myEvent = new BeanChangeEvent(
					BeanChangeEvent.Type.UPDATE, this, event);
			this.thisBeanChangeListener.notifyChange(myEvent);
		}
	}

	public final Resolver getResolver() {
		return beanResolver;
	}

	public final DdiBeanFactory getBeanFactory() {
		return beanFactory;
	}

}
